# macOS 右键菜单 PDF 翻译功能配置教程

本教程将指导您配置 macOS 右键菜单，实现在任意位置对 PDF 文件进行快速翻译。

## 功能效果

- 在 Finder 中右键点击任意 PDF 文件
- 选择"翻译 PDF 为双栏"
- 自动在原文件位置生成翻译后的 `-dual.pdf` 文件
- 全程显示进度通知

## 前置要求

1. 已完成 Zotero PDF 翻译服务的基础配置
2. 已安装必要的 Python 依赖包：
    ```bash
    conda activate zotero-pdf2zh
    pip install requests
    ```

## 配置步骤

### 步骤 1：验证脚本安装

确认以下文件已正确创建：

- `/Users/apple/Documents/zotero-pdf2zh/translate_pdf_client.py`
- `/Users/apple/Scripts/translate_pdf_quick_action.sh`

运行测试脚本验证功能：

```bash
cd /Users/apple/Documents/zotero-pdf2zh
python test_quick_action.py
```

### 步骤 2：创建 Automator Quick Action

1. **打开 Automator**

    - 在 Spotlight 中搜索 "Automator" 并打开
    - 或者：应用程序 → Automator

2. **创建新的 Quick Action**

    - 选择"新建文稿"
    - 选择"快速操作"（Quick Action）
    - 点击"选取"

3. **配置工作流接收设置**

    - 在顶部设置：
        - 工作流程接收当前：**PDF 文件**
        - 位于：**Finder.app**
        - 图像：选择一个合适的图标（可选）
        - 颜色：选择喜欢的颜色（可选）

4. **添加运行 Shell 脚本动作**

    - 在左侧动作库中搜索"运行 Shell 脚本"
    - 双击或拖拽到右侧工作区

5. **配置 Shell 脚本**

    - Shell：**/bin/bash**
    - 传递输入：**作为自变量**
    - 脚本内容：

    ```bash
    /Users/apple/Scripts/translate_pdf_quick_action.sh "$@"
    ```

6. **保存 Quick Action**
    - 按 ⌘+S 保存
    - 名称：**翻译 PDF 为双栏**
    - 位置：默认（iCloud Drive 或本地）

### 步骤 3：授予必要权限

首次使用时，macOS 可能要求授予以下权限：

1. **Finder 访问权限**

    - 系统偏好设置 → 安全性与隐私 → 隐私
    - 选择"自动化"
    - 确保 Automator 和 Finder 已勾选

2. **通知权限**
    - 系统偏好设置 → 通知与专注模式
    - 找到 Terminal 或 terminal-notifier
    - 允许通知

### 步骤 4：使用方法

1. 在 Finder 中找到要翻译的 PDF 文件
2. 右键点击文件
3. 选择"快速操作" → "翻译 PDF 为双栏"
4. 等待翻译完成（会显示通知）
5. 翻译完成后，会在同目录生成 `-dual.pdf` 文件

## 故障排除

### 问题 1：右键菜单中没有出现选项

- 确认 Quick Action 已正确保存
- 重启 Finder：按住 Option 键，右键点击 Finder 图标，选择"重新开启"
- 检查系统偏好设置 → 扩展 → Finder，确保已启用

### 问题 2：点击后没有反应

- 查看日志文件：`~/Library/Logs/PDFTranslateQuickAction.log`
    ```bash
    tail -f ~/Library/Logs/PDFTranslateQuickAction.log
    ```
- 确认 Shell 脚本有执行权限：
    ```bash
    chmod +x /Users/apple/Scripts/translate_pdf_quick_action.sh
    ```

### 问题 5：权限错误 (Operation not permitted)

如果遇到权限错误，日志文件已更改到用户库目录：

- 新日志位置：`~/Library/Logs/PDFTranslateQuickAction.log`
- 这个位置对 Automator 始终可写

### 问题 3：提示找不到 Python 环境

- 确认 conda 环境已创建：
    ```bash
    conda env list | grep zotero-pdf2zh
    ```
- 修改 Shell 脚本中的 Python 路径

### 问题 4：翻译服务未启动

- 脚本会自动尝试启动服务
- 如果失败，手动启动：
    ```bash
    cd /Users/apple/Documents/zotero-pdf2zh
    conda activate zotero-pdf2zh
    python server.py
    ```

## 高级配置

### 自定义翻译参数

编辑 `translate_pdf_client.py`，修改默认翻译参数：

```python
request_data = {
    # ... 其他参数
    'service': 'deepseek',  # 更改翻译服务
    'threadNum': 8,         # 增加线程数
    'sourceLang': 'en',     # 源语言
    'targetLang': 'zh'      # 目标语言
}
```

### 添加更多输出格式

在 Quick Action 中可以添加参数，支持不同的输出格式：

- `-mono.pdf`：单栏翻译
- `-dual.pdf`：双栏对照（默认）
- `-compare.pdf`：左右对比
- `-single-compare.pdf`：单页对比

### 批量处理

创建一个新的 Quick Action，支持选择多个 PDF 文件同时翻译：

```bash
for pdf in "$@"; do
    /Users/apple/Scripts/translate_pdf_quick_action.sh "$pdf" &
done
wait
```

## 注意事项

1. **性能考虑**

    - 大文件翻译可能需要较长时间
    - 建议同时翻译的文件不超过 3 个

2. **磁盘空间**

    - 翻译后的文件会保存在原位置
    - 临时文件保存在 `translated/` 目录

3. **API 限制**
    - 注意翻译服务的 API 调用限制
    - DeepSeek 等服务可能有并发限制

## 卸载方法

如需移除此功能：

1. 删除 Quick Action：

    - 打开 Finder
    - 前往 `~/Library/Services/`
    - 删除"翻译 PDF 为双栏.workflow"

2. 删除相关脚本：
    ```bash
    rm /Users/apple/Scripts/translate_pdf_quick_action.sh
    rm /Users/apple/Documents/zotero-pdf2zh/translate_pdf_client.py
    ```

---

配置完成后，您就可以在任意位置快速翻译 PDF 文件了！如有问题，请查看日志文件或联系技术支持。
